%{
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>


#include "a.h"
#include "a.tab.h"


	LINE *linebase;
	LINE *current_line;
	LINE *next_line;
	VARIABLE *variablebase;
	VARIABLE *placeholder;
	NEXT *nextbase;
	SUB *subbase;
	OPEN *openbase;
	DATA *database;
	FUNC *funcbase;
//	map<int,LINE *> linemap;
	char the_str[1024];
	int the_ptr;
	int prevx;
	short running;
	char run_program[40];

#define C the_str[the_ptr]
#define C_INCR the_str[the_ptr++]

#define YY_INPUT(buf,result,max_size) { \
	if (the_str) \
		*buf = C_INCR; \
	result = (the_str && *buf) ? 1 : YY_NULL; \
}

void yyparse(void *);


%}


DIGIT	[0-9]
ID	[A-Z][A-Z0-9]*
STRING	"\""[^\"]*"\""

%%

{DIGIT}+	{
			yylval.d = atof(yytext);
			return NUM;
		}

{DIGIT}*"."{DIGIT}* {
			yylval.d = atof(yytext);
			return NUM;
		}

{STRING}	{
			strcpy(yylval.s,yytext + 1);
			yylval.s[strlen(yylval.s) - 1] = 0;
			return STRING;
		}

END		return End;
FOR		return For;
NEXT		return Next;
DATA		{
			prevx = the_ptr;
			while (C && C != ':')
			{
				yylval.s[the_ptr - prevx] = C;
				the_ptr++;
			}
			yylval.s[the_ptr - prevx] = 0;
			return Data;
		}
INPUT		return Input;
DEL		return Del;
DIM		return Dim;
READ		return Read;

GR		return Gr;
TEXT		return Text;
PR		return Pr;
IN		return In;
CALL		return Call;
PLOT		return Plot;
HLIN		return Hlin;
VLIN		return Vlin;

HGR2		return Hgr2;
HGR		return Hgr;
HCOLOR		return Hcolor;
HPLOT		return Hplot;
DRAW		return Draw;
XDRAW		return Xdraw;
HTAB		return Htab;
HOME		return Home;

ROT		return Rot;
SCALE		return Scale;
SHLOAD		return Shload;
TRACE		return Trace;
NOTRACE		return Notrace;
NORMAL		return Normal;
INVERSE		return Inverse;
FLASH		return Flash;

COLOR		return Color;
POP		return Pop;
VTAB		return Vtab;
HIMEM		return Himem;
LOMEM		return Lomem;
ONERR		return Onerr;
RESUME		return Resume;
RECALL		return Recall;

STORE		return Store;
SPEED"="	return Speed;
LET		return Let;
GOTO		return Goto;
RUN		return Run;
IF		return If;
RESTORE		return Restore;

GOSUB		return Gosub;
RETURN		return Return;
REM		{
			strcpy(yylval.s,the_str + the_ptr);
			C = 0;
			return Rem;
		}
STOP		return Stop;
ON		return On;
WAIT		return Wait;
LOAD		return Load;
SAVE		return Save;

DEF		return Def;
POKE		return Poke;
PRINT		return Print;
CONT		return Cont;
LIST		return List;
CLEAR		return Clear;
GET		return Get;
NEW		return New;

TAB		return Tab;
TO		return To;
FN		return Fn;
SPC		return Spc;
THEN		return Then;
AT		return At;
NOT		return Not;
STEP		return Step;

AND		return And;
OR		return Or;

SGN		return Sgn;
INT		return Int;
ABS		return Abs;
USR		return Usr;
FRE		return Fre;
SCRN		return Scrn;

PDL		return Pdl;
POS		return Pos;
SQR		return Sqr;
RND		return Rnd;
LOG		return Log;
EXP		return Exp;
COS		return Cos;
SIN		return Sin;

TAN		return Tan;
ATN		return Atn;
PEEK		return Peek;
LEN		return Len;
STR"$"		return Str;
VAL		return Val;
ASC		return Asc;
CHR"$"		return Chr;

LEFT"$"		return Left;
RIGHT"$"	return Right;
MID"$"		return Mid;


"<"[ ]*"="		return LTEQ;
"<"[ ]*">"		return NEQ;
">"[ ]*"="		return GTEQ;

","|":"|";"	return *yytext;

"="|"<"|">"|"("|")" {
			return *yytext;
		}
"*"|"/"|"+"|"-" return *yytext;

{ID}"$"		{
			strcpy(yylval.s,yytext);
			return STRINGVAR;
		}

{ID}"%"		{
			strcpy(yylval.s,yytext);
			return NUMVAR;
		}

{ID}		{
			strcpy(yylval.s,yytext);
			return IDENTIFIER;
		}

[ \t\n]

"\""[^\"]*

.		{
			printf("Unrecognized char '%c'\n",*yytext);
			exit(-1);
		}

%%

char applesoft_tokens[][8]=
{
	"END", "FOR", "NEXT", "DATA", "INPUT", "DEL", "DIM", "READ",
	"GR", "TEXT", "PR#", "IN#", "CALL", "PLOT", "HLIN", "VLIN",

	"HGR2", "HGR", "HCOLOR=", "HPLOT", "DRAW", "XDRAW", "HTAB", "HOME",
	"ROT=", "SCALE=", "SHLOAD", "TRACE", "NOTRACE", "NORMAL", "INVERSE", "FLASH",

	"COLOR=", "POP", "VTAB", "HIMEM:", "LOMEM:", "ONERR", "RESUME", "RECALL",
	"STORE", "SPEED=", "LET", "GOTO", "RUN", "IF", "RESTORE", "&",

	"GOSUB", "RETURN", "REM", "STOP", "ON", "WAIT", "LOAD", "SAVE",
	"DEF", "POKE", "PRINT", "CONT", "LIST", "CLEAR", "GET", "NEW",

	"TAB(", "TO", "FN", "SPC(", "THEN", "AT", "NOT", "STEP",
	"+", "-", "*", "/", "^", "AND", "OR", ">",
	"=", "<", "SGN", "INT", "ABS", "USR", "FRE", "SCRN(",
	"PDL", "POS", "SQR", "RND", "LOG", "EXP", "COS", "SIN",
	"TAN", "ATN", "PEEK", "LEN", "STR$", "VAL", "ASC", "CHR$",
	"LEFT$", "RIGHT$", "MID$", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "(", "(", "("
};

int yywrap()
{
	return 1;		// end of file
}

void yyerror(char *s)
{
	int i;

	printf("\n***\n");
	printf("%s\n",the_str);
	for (i = 0; i < the_ptr; i++)
		printf(" ");
	printf("^ %s\n",s);
	exit(-1);
}

void addlist(void *_base,void *_item)
{
	LINE **base = (LINE **)_base;
	LINE *item = (LINE *)_item;
	LINE *q;

	item -> next = NULL;
	q = *base;
	if (!q)
		*base = item;
	else
	{
		while (q -> next)
			q = q -> next;
		q -> next = item;
	}
}

void removelist(void *_base,void *_item)
{
	LINE **base = (LINE **)_base;
	LINE *item = (LINE *)_item;
	LINE *q,*prev;

	if (item == *base)
		*base = item -> next;
	else
	{
		for (q = *base; q; q = q -> next)
			if (item == q)
			{
				prev -> next = item -> next;
				break;
			}
			else
				prev = q;
	}
}

void read_file(char *filename)
{
	FILE *fil;
	LINE *ln;
	int parent;
	int child;
	short size;
	short q;	// quote
	short ifc;
	short data;
	unsigned char c_length;
	unsigned char c_eight;
	unsigned char c_line1;
	unsigned char c_line2;
	unsigned char c;
	char slask[1024];

	if ((fil = fopen(filename,"rb")) != NULL)
	{
		// 2 bytes size
		fread(&size,1,2,fil);
		while (!feof(fil))
		{
			// 1 byte length, 1 byte == 8
			fread(&c_length,1,1,fil);
			fread(&c_eight,1,1,fil);
			if (!c_eight)
			{
				break;
			}
			// 2 bytes line number
			fread(&c_line1,1,1,fil);
			fread(&c_line2,1,1,fil);
			ln = (LINE *)malloc(sizeof(LINE));
			ln -> line = (((int)c_line2) << 8) + c_line1;
			ln -> parent = ln -> line;
			ln -> child = 0;
			// line data
			fread(&c,1,1,fil);
			*slask = 0;
			q = 0;
			ifc = 0;
			data = 0;
			parent = ln -> line;
			child = 1;
			while (c && !feof(fil))
			{
				if (c >= 0x80)
				{
					if (c == 0x83) // Data
						data = 1;
					if (c == 0xad) // If
						ifc = 1;
					if (ifc && *slask && (c == 0xc4 || c == 0xab)) // Then / Goto
					{
						ln -> the_str = (char *)malloc(strlen(slask) + 1);
						strcpy(ln -> the_str,slask);
						if (*slask)
							addlist(&linebase,ln);
						else
							free(ln);
						if (data && *slask)
						{
							strcpy(the_str,slask);
							the_ptr = 0;
							current_line = ln;
							yyparse(NULL);
						}

						ln = (LINE *)malloc(sizeof(LINE));
						ln -> line = -1;
						ln -> parent = parent;
						ln -> child = child++;
						*slask = 0;
						q = 0;
						ifc = 0;
						data = 0;
					}
					sprintf(slask + strlen(slask)," %s ",applesoft_tokens[c - 0x80]);
				}
				else
				if (c == ':' && !q)
				{
					ln -> the_str = (char *)malloc(strlen(slask) + 1);
					strcpy(ln -> the_str,slask);
					if (*slask)
						addlist(&linebase,ln);
					else
						free(ln);
					if (data && *slask)
					{
						strcpy(the_str,slask);
						the_ptr = 0;
						current_line = ln;
						yyparse(NULL);
					}

					ln = (LINE *)malloc(sizeof(LINE));
					ln -> line = -1;
					ln -> parent = parent;
					ln -> child = child++;
					*slask = 0;
					q = 0;
					ifc = 0;
					data = 0;
				}
				else
				{
					sprintf(slask + strlen(slask),"%c",c);
					if (c == 34)
						q = !q;
				}
				fread(&c,1,1,fil);
			}
			ln -> the_str = (char *)malloc(strlen(slask) + 1);
			strcpy(ln -> the_str,slask);
			if (*slask)
				addlist(&linebase,ln);
			else
				free(ln);
			if (data && *slask)
			{
				strcpy(the_str,slask);
				the_ptr = 0;
				current_line = ln;
				yyparse(NULL);
			}
		}
		fclose(fil);
	}
	else
	{
		printf("Couldn't open '%s'...\n",filename);
		exit(-1);
	}
}

void execute()
{
	current_line = linebase;
	while (current_line)
	{
		next_line = current_line -> next;
		strcpy(the_str,current_line -> the_str);
		the_ptr = 0;
#ifdef DEBUGEXPR
printf(" %4d %s\n",current_line -> line,current_line -> the_str);
#endif
		placeholder = NULL;
		yyparse(NULL);
		if (placeholder)
			placeholder -> value = placeholder -> fnvalue;
		current_line = next_line;
	}
}

void finish()
{
	LINE *ln;
	LINE *tmpln;
	VARIABLE *v;
	VARIABLE *tmpv;
	NEXT *nx;
	NEXT *tmpnx;
	SUB *sub;
	SUB *tmpsub;
	OPEN *o;
	OPEN *tmpo;
	DATA *d;
	DATA *tmpd;
	FUNC *f;
	FUNC *tmpf;

	for (ln = linebase; ln; ln = tmpln)
	{
		tmpln = ln -> next;
		free(ln -> the_str);
		free(ln);
	}
	for (v = variablebase; v; v = tmpv)
	{
		tmpv = v -> next;
		free(v);
	}
	for (nx = nextbase; nx; nx = tmpnx)
	{
		tmpnx = nx -> next;
		free(nx);
	}
	for (sub = subbase; sub; sub = tmpsub)
	{
		tmpsub = sub -> next;
		free(sub);
	}
	for (o = openbase; o; o = tmpo)
	{
		tmpo = o -> next;
		fclose(o -> fil);
		free(o);
	}
	for (d = database; d; d = tmpd)
	{
		tmpd = d -> next;
		free(d -> data);
		free(d);
	}
	for (f = funcbase; f; f = tmpf)
	{
		tmpf = f -> next;
		free(f);
	}
}

int main(int argc,char *argv[])
{
	LINE *ln;
	int loop;
	short source = 0;

	for (loop = 1; loop < argc; loop++)
		if (!strcmp(argv[loop],"-source"))
			source++;

	if (argc > 1)
	{
		strcpy(run_program,argv[1]);
		if (source)
		{
			linebase = NULL;
			variablebase = NULL;
			nextbase = NULL;
			subbase = NULL;
			openbase = NULL;
			database = NULL;
			funcbase = NULL;

			running = 0;
			read_file(argv[1]);
			for (ln = linebase; ln; ln = ln -> next)
			{
				if (ln -> line > -1)
					printf(" %5d",ln -> line);
				else
					printf("      ");
				printf(" %s\n",ln -> the_str);
				strcpy(the_str,ln -> the_str);
				the_ptr = 0;
				yyparse(NULL);
			}
			finish();
			return 0;
		}
		do
		{
			linebase = NULL;
			variablebase = NULL;
			nextbase = NULL;
			subbase = NULL;
			openbase = NULL;
			database = NULL;
			funcbase = NULL;

			running = 0;
			read_file(run_program);
			file_init();

			*run_program = 0;
			running = 1;
			execute();

			finish();
		} while (*run_program);
	} else
	{
		printf("Usage: %s <A file> [-source]\n",*argv);
	}
	return 0;
}

